# During the space shuttle program, the space shuttle's flight computer sysytem consisted of
# three, redundant computers. Ideally, all three computers would be in agreement, but only
# two needed to be in agreement in order for the result of a calculation to be accepted. This
# program simulates this three computer system by asking the user to enter three numbers, one
# after another. If any two "computers" are in agreement, the result is diaplayed. If no
# computers are in agreement, an error message is displayed. Since the entire purpose of this
# program is to demonstrate exception handling, exception handling is implemented to account
# for a condition where one of the inputs is not a number. In this case, a separate error
# message is displayed.

# The "main" function is where all of the action will take place.
def main():
    # Right away, we'll set up a "try" block. This is part of our exception handling routine.
    # The Python interpreter will test this block of code for errors. This includes any input
    # errors that may crop up.
    try:
        # Let's get some input from the user. Since we're simulating the computers on the space
        # shuttle, it makes sense that numeric data would be in the form of floating point numbers.
        x = float(input("Enter a number: "))
        y = float(input("Enter another number: "))
        z = float(input("Enter another number: "))

        # Let's check to see if any of the computers are in agreement.
        if x == y or x == z:
            print("The result is: " + str(x))
        elif y == z:
            print("The result is: " + str(y))
        # If no computers agree, display an error message.
        else:
            print("ERROR! No computers agree!")
    # The "except" block is where we handle any errors that may have cropped up. For example,
    # if the user enters a string instead of a number, our if, elif, else logic would fail.
    # In that case, we'll need to display a new error.
    except:
        print("Houston, we've had a problem.")

if __name__=='__main__':
    main()
